/* -------------------------------------------------------------------------- */
/*  Last Updated Ver.1.0	2014.07.15										*/
/*		Copyright (C) 2014 Japan Meteorological Agency  All rights reserved */
/* -------------------------------------------------------------------------- */

#include "sample_decode.h"
#include "kknc_template.h"

#ifdef IS_LITTLE_ENDIAN
#define Fread fread_little_endian
#else
#define Fread fread
#endif

/*-------------------------------------------------------------------------*/
void fread_little_endian(void *d, int len, int num, FILE * fp)
{
	unsigned char uc[8], *ud;
	int i, j, k;
	int pos;

	ud = d;
	pos=ftell(fp);
	if (len == 1){
		fread(d, len, num, fp);
		fseek(fp,pos+len*num,0);
	}else {
		for (i = 0, k = 0; i < num; i++, k += len) {
			fread(uc, len, 1, fp);
			fseek(fp,pos+k+len,0);
			for (j = 0; j < len; j++)
				*(ud + k + j) = uc[len - 1 - j];
		}
	}
}

/*------------------------------------------------------------------------*/
void init_sect(ST_SECT ss[])
{
	int i, j;
	char c[2];

	sect_num = 0;
	while (strlen(kn_prr[sect_num]) != 0)
		sect_num++;
	for (i = 0; i < sect_num; i++) {
		ss[i].num = strlen(kn_prr[i]);
		//ss[i].len = (int *) malloc(sizeof(int *) * ss[i].num);
		ss[i].len = (int *) malloc(sizeof(int) * ss[i].num);
		for (j = 0; j < ss[i].num; j++) {
			strncpy(c, &kn_prr[i][j], 1);
			c[1]='\0';
			*(ss[i].len + j) = atoi(c);
		}
		ss[i].v =
			(unsigned char **) malloc(sizeof(unsigned char *) *
									  ss[i].num);
		for (j = 0; j < ss[i].num; j++)
			*(ss[i].v + j) = NULL;
	}
}

/*------------------------------------------------------------------------*/
int read_sect(ST_SECT ss[], FILE * fp)
{
	int i, nn, mm, si;
	unsigned int slen;
	unsigned short *us, ud;
	unsigned char sn;

	Fread(&slen, 4, 1, fp);
	if (memcmp(&slen, "7777", 4) == 0) {
		si = 8;
		return (si);
#ifdef IS_LITTLE_ENDIAN
	} else if (memcmp(&slen, "BIRG", 4) == 0) {
#else
	} else if (memcmp(&slen, "GRIB", 4) == 0) {
#endif
		si = 0;
		slen = 16;
		Fread(&ud, 2, 1, fp);
		*(ss[si].v + 0) =
			(unsigned char *) realloc(*(ss[si].v + 0),
									  sizeof(unsigned int));
		*(ss[si].v + 1) =
			(unsigned char *) realloc(*(ss[si].v + 1),
									  sizeof(unsigned short));
		memcpy(*(ss[si].v + 0), &slen, 4);
	} else {
		Fread(&sn, 1, 1, fp);
		si = (int) sn;
		if (si >= 3)
			si--;
		*(ss[si].v + 0) =
			(unsigned char *) realloc(*(ss[si].v + 0),
									  sizeof(unsigned int));
		*(ss[si].v + 1) =
				(unsigned char *) realloc(*(ss[si].v + 1),
									  sizeof(unsigned char));
		memcpy(*(ss[si].v + 0), &slen, 4);
		memcpy(*(ss[si].v + 1), &sn, 1);
	}

	for (i = 2; i < ss[si].num; i++) {
		if (*(ss[si].len + i) == 0) {
			us = (unsigned short *) (*(ss[si].v + i - 2));
			nn = (*(ss[si].len + i - 2) == 4) ? sizeof(unsigned char)
				: sizeof(unsigned short);
			mm = (*(ss[si].len + i - 2) == 4) ? slen - 5 : *us;
		} else {
			nn = *(ss[si].len + i);
			mm = 1;
		}
			*(ss[si].v + i) =
				(unsigned char *) realloc(*(ss[si].v + i), (size_t) nn * mm);
		
		Fread(*(ss[si].v + i), nn, mm, fp);
	}

	return (si);
}

/*-------------------------------------------------------------------------*/
int dec_data(ST_SECT ss[], int **lv)
{
	int nin, nout, maxv, nbit, rt;
	unsigned int *ui;
	unsigned short *us;

	ui = (unsigned int *) *(ss[4].v + 2);
	nout = *ui;
	nbit = **(ss[4].v + 4);
	us = (unsigned short *) *(ss[4].v + 5);
	maxv = *us;
	ui = (unsigned int *) *(ss[6].v + 0);
	nin = *ui - 5;

	*lv = (int *) malloc(sizeof(int) * nout);
	rt = decode_rlen_nbit(*lv, sizeof(int), *(ss[6].v + 2), nin, nout,
						  maxv, nbit);

	return (rt);
}

/*-------------------------------------------------------------------------*/
void print_info(ST_SECT ss[], int sn,int fcst,int tile_num)
{
	int i, j, k;
	unsigned char dam[5];
	unsigned long long *ull;
	int *ii;
	unsigned short *us, *n;
	if (sn >= 2) printf("========== focast time %d tile %d ===========\n",fcst,tile_num);
	printf("========== SECTION %1.1d ===========\n",
		   (sn >= 2) ? sn + 1 : sn);
	for (i = 0, j = 1; i < ss[sn].num; j += *(ss[sn].len + i), i++) {
		if (*(ss[sn].len + i) == 1) {
			if (**(ss[sn].v + i) == 0xff)
				printf("	%3d	: 0x%2.2x\n", j, **(ss[sn].v + i));
			else
				printf("	%3d	: %d\n", j, **(ss[sn].v + i));
		} else if (*(ss[sn].len + i) == 8) {
			if (sn == 0) {
				ull = (unsigned long long *) *(ss[sn].v + i);
				printf("%4d --%4d: %d\n", j, j + *(ss[sn].len + i) - 1,
					   (unsigned int) *ull);
			} else {
				printf("%4d --%4d: ", j, j + *(ss[sn].len + i) - 1);
				for (k = 0; k < 8; k++)
					printf("%2.2x", *(*(ss[sn].v + i) + k));
				printf("\n");
			}
		} else if (*(ss[sn].len + i) == 4) {
			if (i==12 && sn ==3){
		/* only fcst_time is signed int */
				dam[0]=ss[sn].v[i][0];dam[1]=ss[sn].v[i][1];
				dam[2]=ss[sn].v[i][2];dam[3]=ss[sn].v[i][3]&0x7f;
				ii=(int *)dam;
				if (ss[sn].v[i][3]&0x80){
					*ii *=-1;
				}
			} else {
				ii = (int *) *(ss[sn].v + i);
			}
			if (*ii >= 0 || (i == 12 && sn == 3))
		/* only fcst_time is signed int */
				printf("%4d --%4d: %d\n", j, j + *(ss[sn].len + i) - 1,*ii);
			else
				printf("%4d --%4d: 0x%8.8x\n", j,
					   j + *(ss[sn].len + i) - 1, *ii);
		} else if (*(ss[sn].len + i) == 2) {
			us = (unsigned short *) *(ss[sn].v + i);
			if (*us == 0xffff)
				printf("%4d --%4d: 0x%4.4x\n", j,
					   j + *(ss[sn].len + i) - 1, *us);
			else
				printf("%4d --%4d: %d\n", j, j + *(ss[sn].len + i) - 1, *us);
		} else if (sn == 3 || sn == 4) {
			n = (unsigned short *) *(ss[sn].v + i - 2);
			us = (unsigned short *) *(ss[sn].v + i);
			for (k = 0; k < *n; k++) {
				if (*(us + k) == 0xffff)
					printf("%4d --%4d: 0x%4.4x\n", j + 2 * k,
						   j + 2 * k + 1, *(us + k));
				else
					printf("%4d --%4d: %d\n", j + 2 * k, j + 2 * k + 1,
						   *(us + k));
			}
		}
	}
	fflush(stdout);
}

/*-------------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
	ST_SECT ss[8];
	FILE *fp, *fpo;
	char fname[512], gname[512], suffix[160], fcs[160],ffm[160];
	char dam[10];
	int ftime,tile,fcst,bfcst,idam;
	int *out_data,tile_num;
	short rain;
	int sn, *lv, gn, sff = 0, ll,ii;

	if (argc <5 ) {
		fprintf(stderr, "\n\nusage: grib2_dec ***_grib2.bin ftime tile [txt|bin1|bin2] \n\n");
		fprintf(stderr,
"　このサンプルプログラムは、高解像度降水ナウキャストのデータ\
（gzip圧縮を解凍したファイル）について、解析・予報時刻の種類、\
タイル(0から始まる領域)を与えることで、当該タイルの各オクテット情報を\
標準出力に表示するとともに、デコードしたデータをファイルに出力します。\n\
　出力するファイルはバイナリ、テキストのいずれかをオプションで指定します。\n\
　出力ファイル名は入力ファイルの[grib2.bin]以下を削除し、予報時間、\
タイル番号を加え、拡張子をtxtまたはbinとしたものです。\n\
　出力するディレクトリは入力ファイルと同じ場所です。\n\
　各オプション説明\n\
　　***_grib2.bin:対象とするファイル名。非圧縮データのみ対応。\n\
　　ftime :解析または予報時刻を指定。\n\
　　　0=解析、-1=誤差、5=5分後予測値、10=10分後予測値、...\n\
　　tile :抽出したい領域の0から始まる番号。\n\
　　txt|bin1|bin2 :出力するデータを指定。\n\
　　　txt=雨量値（または雨量強度）を100倍したスペース区切りテキスト。\n\
　　　bin1=1バイトレベル値（格納されている値そのまま）のバイナリファイル。\n\
　　　bin2=2バイトの雨量値(または雨量強度）を100倍したバイナリファイル。\n\
例）2014年7月9日05時(UTC)のデータの解析値の966番目のタイルをデコードする場合\n\
./grib2_dec data/Z__C_RJTD_20140709050000_NOWC_GPV_Ggis0p25km_Prr05lv_Aper5min_FH0000-0030_grib2.bin 0 966 txt\n\
出力されるファイル\n\
data/Z__C_RJTD_20140709050000_NOWC_GPV_Ggis0p25km_Prr05lv_Aper5min_FH0000-0030_0_966.txt\n");
		return(1);
	} else {
		strcpy(fname, argv[1]);
		ftime=atoi(argv[2]);
		tile=atoi(argv[3]);
		sff=-1;
		if (strcmp(argv[4], "bin1") == 0) {
			strcpy(suffix, ".bin1");
			sff = 0;
		} else if (strcmp(argv[4], "bin2") == 0) {
			strcpy(suffix, ".bin2");
			sff = 1;
		} else if (strcmp(argv[4],"txt") == 0){
			strcpy(suffix, ".txt");
			sff = 2;
		}
		if (sff<0 || ftime<-1 || tile<0) return(3);
	}
	if ((fp = fopen(fname, "rb")) == NULL) {
		fprintf(stderr, "grib2 file <%s> open error!!\n", fname);
		return(1);
	}
	fseek(fp,0,0);
	init_sect(ss);
	fcst=-100;
	bfcst=-2;
	tile_num=0;
	while ((sn = read_sect(ss, fp)) != 8) {
		if (sn == 3) {
			if (ss[3].v[5][0]==8){
				/*5分間降水量*/
				if (ss[3].v[27][0]==195) fcst=-1;
				else {
					dam[3]=ss[3].v[12][3]&0x7f;
					dam[2]=ss[3].v[12][2];dam[1]=ss[3].v[12][1];dam[0]=ss[3].v[12][0];
					memcpy(&idam,dam,4);
					if (ss[3].v[12][3]&0x80) idam*=-1;
					idam+=5;
					fcst=idam;
				}
			} else {
				if (ss[3].v[5][0]==214) fcst=-1;
				else {
					dam[3]=ss[3].v[12][3]&0x7f;
					dam[2]=ss[3].v[12][2];dam[1]=ss[3].v[12][1];dam[0]=ss[3].v[12][0];
					memcpy(&idam,dam,4);
					if (ss[3].v[12][3]&0x80) idam*=-1;
					idam+=5;
					fcst=idam;
				}
			}
			if (fcst!=bfcst) tile_num=0;
			bfcst=fcst;
		}
		
		if (sn == 6) {
			if (fcst!=ftime || tile_num != tile) {
				tile_num++;
				continue;
			}
			print_info(ss, sn,fcst,tile_num);
			tile_num++;
			gn = dec_data(ss, &lv);
			if (gn > 0) {
				ll = strlen(fname) - strlen(strstr(fname, "_grib2.bin"));
				strncpy(gname, fname, ll);
				gname[ll] = '\0';
				sprintf(fcs, "_%1d", fcst);
				sprintf(ffm, "_%03d",tile);
				strcat(gname, strcat(fcs, strcat(ffm, suffix)));
				if ((fpo = fopen(gname, "w")) == NULL) {
					fprintf(stderr, "output file <%s> open error!!\n",gname);
					free(lv);
					fclose(fp);
					return(1);
				}
				if (sff == 0){
					fwrite(lv, sizeof(int), gn, fpo);
				} else if (sff==2){
					for (ii=0;ii<gn;ii++){
/*change lev to mm/hr */
						if (lv[ii] == 0){
								fprintf(fpo,"-0001 ");
						} else {
								memcpy(&rain,&ss[4].v[8][(lv[ii]-1)*2],2);
									fprintf(fpo,"%05d ",rain);
						}
					}
				} else if (sff==1){
					out_data=malloc(gn*sizeof(int));
					for (ii=0;ii<gn;ii++){
/*change lev to mm/hr */
						if (lv[ii] == 0){
								out_data[ii]=-1;
						} else {
								memcpy(&rain,&ss[4].v[8][(lv[ii]-1)*2],2);
								out_data[ii]=rain;
						}
					}
					fwrite(out_data,sizeof(int),gn,fpo);
					free(out_data);
				}
				fclose(fpo);
			}
			free(lv);
			for (ii=0;ii<sect_num;ii++){
				free(ss[ii].len);
				for (ll=0;ll<ss[ii].num;ll++){
					if (ss[ii].v[ll]){
						free(ss[ii].v[ll]);
					}
				}
				free(ss[ii].v);
			}
			fclose(fp);
			return (0);
		} else {
			if (sn<2 || (fcst == ftime && tile_num == tile)){
				print_info(ss, sn,fcst,tile_num);
			}
				
		}
	}
	fclose(fp);
	for (ii=0;ii<sect_num;ii++){
		free(ss[ii].len);
		for (ll=0;ll<ss[ii].num;ll++){
			if (ss[ii].v[ll]){
				free(ss[ii].v[ll]);
			}
		}
		free(ss[ii].v);
	}
	return (0);
}

